<?php
require_once '../config/database.php';

try {
    $stmt = $pdo->prepare("SELECT 
        ID,
        ProductImage, 
        ProductName, 
        ProductBrand, 
        ProductCategory, 
        Barcode, 
        BoycottCount, 
        Report 
        FROM {$tables['products']} 
        ORDER BY ProductName ASC");
    $stmt->execute();
    $products = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    header('Content-Type: application/json');
    echo json_encode($products);
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
?> 