<?php
// This is a test script to insert sample category data
// Remove this file after testing

require_once '../config/database.php';

$categoryTable = $tables['categories']; // Get table name from config

try {
    // Sample categories and subcategories
    $sampleData = [
        ['Electronics', 'Mobile Phones'],
        ['Electronics', 'Laptops'],
        ['Electronics', 'Tablets'],
        ['Electronics', ''],
        ['Food & Beverages', 'Snacks'],
        ['Food & Beverages', 'Drinks'],
        ['Food & Beverages', 'Dairy'],
        ['Food & Beverages', ''],
        ['Clothing', 'Shirts'],
        ['Clothing', 'Pants'],
        ['Clothing', 'Shoes'],
        ['Clothing', ''],
        ['Home & Garden', 'Furniture'],
        ['Home & Garden', 'Decor'],
        ['Home & Garden', ''],
        ['Books', ''],
        ['Sports', 'Fitness'],
        ['Sports', 'Outdoor'],
        ['Sports', '']
    ];
    
    // Clear existing data
    $pdo->exec("DELETE FROM {$categoryTable}");
    
    // Insert sample data
    $stmt = $pdo->prepare("INSERT INTO {$categoryTable} (Category, SubCategory) VALUES (?, ?)");
    
    foreach ($sampleData as $data) {
        $stmt->execute([$data[0], $data[1]]);
    }
    
    echo "Sample category data inserted successfully!<br>";
    echo "Categories: Electronics, Food & Beverages, Clothing, Home & Garden, Books, Sports<br>";
    echo "Each category has multiple subcategories as well.";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
?> 