    <?php
    // includes/helpers.php

    // HTML এ ডিসপ্লে করার জন্য আউটপুট স্যানিটাইজ করুন
    function escapeHTML($str) {
        if ($str === null || $str === undefined) {
            return '';
        }
        // htmlentities সকল সম্ভাব্য অক্ষর এনকোড করে, htmlspecialchars এর চেয়ে বেশি শক্তিশালী
        return htmlentities(trim(strval($str)), ENT_QUOTES, 'UTF-8');
    }

    // Image Base64 ডেটা বা URL প্রসেস করে Base64 স্ট্রিং রিটার্ন করুন
    function getImageBase64($imageData, $sourceType = 'none') {
        if (empty($imageData) || $sourceType === 'none') {
            return null; // কোনো ডেটা নেই বা সোর্স টাইপ unknown
        }

        $imageData = trim($imageData);
        if (empty($imageData)) return null; // ডেটা খালি স্ট্রিং

        if ($sourceType === 'file') {
            // ডেটা URL ফর্ম্যাট চেক করুন (যেমন: data:image/png;base64,...)
            if (preg_match('/^data:image\/(.*?);base64,(.*)$/', $imageData, $matches)) {
                 // নিশ্চিত করুন এটি একটি বৈধ ইমেজ MIME টাইপ
                $mime = $matches[1];
                if (!in_array($mime, ['jpeg', 'png', 'gif', 'webp', 'jpg'])) { // অনুমোদিত MIME টাইপ
                     error_log("getImageBase64: Invalid file MIME type: " . $mime);
                     return null;
                }
                return $matches[2]; // বিশুদ্ধ Base64 স্ট্রিং রিটার্ন করুন
            }
            error_log("getImageBase64: Data for source 'file' is not a valid Data URL format.");
            return null;

        } elseif ($sourceType === 'url') {
            // URL ভ্যালিডেট করুন
            if (filter_var($imageData, FILTER_VALIDATE_URL)) {
                $response = false;
                $fetchedContent = null;
                $http_status = 0;

                // cURL ব্যবহার করে URL থেকে কন্টেন্ট Fetch করার চেষ্টা করুন (প্রস্তাবিত)
                if (function_exists('curl_init')) {
                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, $imageData);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); // আউটপুট স্ট্রিং হিসাবে রিটার্ন করুন
                    curl_setopt($ch, CURLOPT_TIMEOUT, 10); // 10 সেকেন্ড timeout
                    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true); // Redirects ফলো করুন
                    curl_setopt($ch, CURLOPT_MAXREDIRS, 5); // সর্বাধিক 5 redirects
                    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true); // SSL ভেরিফাই করুন (প্রোডাকশনে TRUE রাখুন)
                    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2); // SSL হোস্ট ভেরিফাই করুন (প্রোডাকশনে 2 রাখুন)
                    curl_setopt($ch, CURLOPT_USERAGENT, 'AdminDashboard/1.0 (ImageFetcher)'); // ভাল practice
                    // শুধুমাত্র HEAD রিকোয়েস্ট করুন প্রথমে কন্টেন্ট টাইপ চেক করার জন্য (এটি অপশনাল কিন্তু পারফর্মেন্সের জন্য ভাল)
                    // curl_setopt($ch, CURLOPT_NOBODY, true);

                    $fetchedContent = curl_exec($ch);
                    $http_status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                    $curl_error = curl_error($ch);
                    curl_close($ch);

                    if ($fetchedContent === FALSE || $http_status !== 200) {
                        error_log("Failed to fetch image from URL (cURL error: {$curl_error}, Status: {$http_status}): " . $imageData);
                        return null;
                    }

                } elseif (ini_get('allow_url_fopen')) {
                     // cURL না থাকলে file_get_contents ব্যবহার করুন (কম প্রস্তাবিত)
                     error_log("cURL not available. Using file_get_contents for URL fetch.");
                     // HTTP হেডার চেক করার জন্য context ব্যবহার করুন
                     $context = stream_context_create([
                         'http' => [
                             'timeout' => 10,
                             'ignore_errors' => true, // HTTP স্ট্যাটাস কোড 4xx/5xx হলেও কন্টেন্ট Fetch করুন
                             'user_agent' => 'AdminDashboard/1.0 (ImageFetcher)'
                         ]
                     ]);
                     // @ ব্যবহার করে file_get_contents থেকে আসা warning গুলো suppress করুন
                     $fetchedContent = @file_get_contents($imageData, false, $context);

                      if ($fetchedContent === FALSE) {
                           error_log("Failed to fetch image from URL (file_get_contents error): " . $imageData);
                           return null;
                      }
                       // HTTP response header চেক করুন
                       if (isset($http_response_header)) {
                           $is_success = false;
                            foreach($http_response_header as $header) {
                                // স্ট্যাটাস কোড 200 OK খুঁজুন
                                if (preg_match('/^HTTP\/[\d\.]+\s+200\s+OK/i', $header)) {
                                    $is_success = true;
                                    break;
                                }
                                // Content-Type হেডার খুঁজুন
                                if (preg_match('/^Content-Type:\s*image\/(jpeg|png|gif|webp|jpg)/i', $header, $matches)) {
                                    // Content-Type পাওয়া গেছে, আমরা ইমেজ ডেটা পেয়েছি বলে ধরে নিতে পারি
                                    // কিন্তু এটি অবশ্যই HTTP 200 স্ট্যাটাসের সাথে মিলিত হওয়া উচিত
                                }
                            }
                            if (!$is_success) {
                                error_log("Failed to fetch image from URL (bad HTTP status from file_get_contents): " . $imageData);
                                return null;
                            }
                       } else {
                            // $http_response_header পাওয়া যায়নি, সম্ভবত লোকালে ফাইল পাথ
                             error_log("file_get_contents used for URL but no http_response_header found: " . $imageData);
                             // এটি URL হওয়ার কথা, কিন্তু হেডার নেই। সমস্যা হতে পারে।
                             return null; // অথবা কন্টেন্ট টাইপ চেক ছাড়া বেস64 এনকোড করুন (কম নিরাপদ)
                       }

                } else {
                     error_log("getImageBase64: Neither cURL nor allow_url_fopen are enabled. Cannot fetch image from URL.");
                     return null; // URL থেকে Fetch করার কোনো উপায় নেই
                }

                // Fetched Content যদি পাওয়া যায়, নিশ্চিত করুন এটি একটি ইমেজ এবং Base64 এনকোড করুন
                if ($fetchedContent !== null && $fetchedContent !== '') {
                    // Fetch করা ডেটার MIME টাইপ চেক করুন (ম্যাজিক বাইট ব্যবহার করে)
                    $finfo = finfo_open(FILEINFO_MIME_TYPE);
                    if ($finfo) {
                        $mime_type = finfo_buffer($finfo, $fetchedContent);
                        finfo_close($finfo);

                        if (preg_match('/^image\/(jpeg|png|gif|webp|jpg)/i', $mime_type)) {
                            // বৈধ ইমেজ কন্টেন্ট টাইপ
                            return base64_encode($fetchedContent);
                        } else {
                             error_log("getImageBase64: Fetched content from URL is not a valid image MIME type: " . $mime_type . " for URL: " . $imageData);
                             return null; // Fetched Content ইমেজ নয়
                        }
                    } else {
                         error_log("getImageBase64: finfo_open failed. Cannot verify image type from URL.");
                         // finfo না থাকলে রিস্ক নিয়ে Base64 এনকোড করতে পারেন, অথবা fail করতে পারেন। fail করা নিরাপদ।
                         return null;
                    }
                }

            }
            error_log("getImageBase64: Invalid URL format provided for source 'url': " . $imageData);
            return null; // অবৈধ URL ফর্ম্যাট
        }

         // ফলব্যাক: যদি source Type না থাকে কিন্তু ডেটা Base64 মত দেখতে হয়
         // (এটি ব্যবহার করা কম প্রস্তাবিত কারণ source Type নির্ভরযোগ্য নয়)
         // if (!empty($imageData) && preg_match('/^[a-zA-Z0-9\/+=]+$/', $imageData)) {
         //      // এখানে নিশ্চিত হওয়া কঠিন যে এটি একটি Base64 ইমেজ ডেটা, অন্য কিছু নয়
         //      // তাই এই ফলব্যাকটি এড়িয়ে যাওয়াই ভাল
         //      // return $imageData; // দেখতে Base64 মত, রিটার্ন করুন
         // }

         // ডেটা আছে কিন্তু সোর্স টাইপ অজানা বা ডেটা ফর্ম্যাট অপ্রত্যাশিত
         if (!empty($imageData)) {
              error_log("getImageBase64: Data exists but source type is unknown or data format is unexpected.");
         }

        return null; // কোনো শর্ত মেলেনি, রিটার্ন null
    }


    // ডাটাবেসে ডুপ্লিকেট প্রোডাক্ট নাম বা বারকোড চেক করুন
    function checkExistingProduct($conn, $productName, $barcode) {
        $isDuplicateName = false;
        $isDuplicateBarcode = false;

        $productName = trim($productName);
        $barcode = trim($barcode);

        // প্রোডাক্টস টেবিলে ডুপ্লিকেট নাম চেক করুন যদি নাম দেওয়া থাকে এবং খালি না হয়
        if (!empty($productName)) {
            $stmt = $conn->prepare("SELECT COUNT(*) FROM Products WHERE ProductName = :name");
            $stmt->bindParam(':name', $productName, PDO::PARAM_STR);
            $stmt->execute();
            if ($stmt->fetchColumn() > 0) {
                $isDuplicateName = true;
            }
        }

        // প্রোডাক্টস টেবিলে ডুপ্লিকেট বারকোড চেক করুন যদি বারকোড দেওয়া থাকে এবং খালি না হয়
        // বারকোড কলাম খালি বা NULL নয় এমন এন্ট্রিগুলোই চেক করবে
        if (!empty($barcode)) {
            $stmt = $conn->prepare("SELECT COUNT(*) FROM Products WHERE Barcode = :barcode AND Barcode IS NOT NULL AND Barcode != ''");
            $stmt->bindParam(':barcode', $barcode, PDO::PARAM_STR);
            $stmt->execute();
            if ($stmt->fetchColumn() > 0) {
                $isDuplicateBarcode = true;
            }
        }

        return ['isDuplicateName' => $isDuplicateName, 'isDuplicateBarcode' => $isDuplicateBarcode];
    }

    ?>