<?php

// --- Database Configuration ---
$host = "localhost";
$dbName = "digitalb_beaccurate";
$userName = "digitalb_beaccurate";
$pass = "Saiful.1633"; // Be careful exposing passwords directly in code for production
$tableName = "Products";
$idColumn = "id"; // Assuming the primary key column is named 'id'
$reportColumn = "Report"; // The column to update

// --- Input Handling ---
// Get the ID from the URL query string (e.g., update_report.php?id=5)
if (!isset($_GET['id']) || empty(trim($_GET['id']))) {
    http_response_code(400); // Bad Request
    die("Error: Product ID is required. Please provide it like ?id=your_product_id");
}

// Sanitize and validate the ID (ensure it's an integer)
$productId = filter_var($_GET['id'], FILTER_VALIDATE_INT);

if ($productId === false || $productId <= 0) {
    http_response_code(400); // Bad Request
    die("Error: Invalid Product ID provided. ID must be a positive integer.");
}

// --- Database Connection (PDO) ---
$dsn = "mysql:host=$host;dbname=$dbName;charset=utf8mb4";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION, // Throw exceptions on errors
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,       // Fetch associative arrays
    PDO::ATTR_EMULATE_PREPARES   => false,                  // Use native prepared statements
];

try {
    $pdo = new PDO($dsn, $userName, $pass, $options);
} catch (\PDOException $e) {
    http_response_code(500); // Internal Server Error
    // In production, log this error instead of showing details to the user
    die("Database connection failed: " . $e->getMessage());
}

// --- Update Logic ---
// Prepare the SQL statement to prevent SQL injection
// This atomically increments the value in the database (Report = Report + 1)
// Using backticks `` around table and column names is good practice,
// especially if they might be reserved keywords.
$sql = "UPDATE `" . $tableName . "` SET `" . $reportColumn . "` = `" . $reportColumn . "` + 1 WHERE `" . $idColumn . "` = :id";

try {
    $stmt = $pdo->prepare($sql);

    // Bind the product ID parameter
    // PDO::PARAM_INT ensures the value is treated as an integer
    $stmt->bindParam(':id', $productId, PDO::PARAM_INT);

    // Execute the update query
    $stmt->execute();

    // Check if any rows were actually affected
    $rowCount = $stmt->rowCount();

    if ($rowCount > 0) {
        // Success
        http_response_code(200); // OK
        echo "Success: Report count for Product ID " . htmlspecialchars($productId) . " incremented successfully.";
    } else {
        // No rows affected - likely means the ID didn't exist
        http_response_code(404); // Not Found
        echo "Notice: No product found with ID " . htmlspecialchars($productId) . ". No update performed.";
    }

} catch (\PDOException $e) {
    http_response_code(500); // Internal Server Error
    // In production, log this error
    die("Update failed: " . $e->getMessage());
}

// --- Clean up (Optional for PDO, happens automatically) ---
$pdo = null;
$stmt = null;

?>